// This file was automatically generated by VS extension Windows Machine Learning Code Generator v3
// from model file ImageClassifierModel.onnx
// Warning: This file may get overwritten if you add add an onnx file with the same name
using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Windows.Media;
using Windows.Storage;
using Windows.Storage.Streams;
using Windows.AI.MachineLearning;
namespace ImageClassifierAppUWP
{
    
    public sealed class ImageClassifierModelInput
    {
        public ImageFeatureValue data; // BitmapPixelFormat: Bgra8, BitmapAlphaMode: Premultiplied, width: 224, height: 224
    }
    
    public sealed class ImageClassifierModelOutput
    {
        public TensorString classLabel; // shape(-1,1)
        public IList<IDictionary<string,float>> loss;
    }
    
    public sealed class ImageClassifierModelModel
    {
        private LearningModel model;
        private LearningModelSession session;
        private LearningModelBinding binding;
        public static async Task<ImageClassifierModelModel> CreateFromStreamAsync(IRandomAccessStreamReference stream)
        {
            ImageClassifierModelModel learningModel = new ImageClassifierModelModel();
            learningModel.model = await LearningModel.LoadFromStreamAsync(stream);
            learningModel.session = new LearningModelSession(learningModel.model);
            learningModel.binding = new LearningModelBinding(learningModel.session);
            return learningModel;
        }
        public async Task<ImageClassifierModelOutput> EvaluateAsync(ImageClassifierModelInput input)
        {
            binding.Bind("data", input.data);
            var result = await session.EvaluateAsync(binding, "0");
            var output = new ImageClassifierModelOutput();
            output.classLabel = result.Outputs["classLabel"] as TensorString;
            output.loss = result.Outputs["loss"] as IList<IDictionary<string,float>>;
            return output;
        }
    }
}

